<?php
/* --------------------------------------------------------------
 ContentNavigationItem.php 2019-12-12
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2019 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Admin\Application\Http;

/**
 * Class ContentNavigationItem
 * @package Gambio\Core\Application\Http
 */
class ContentNavigationItem
{
    /**
     * @var string
     */
    private $name;
    
    /**
     * @var string
     */
    private $url;
    
    /**
     * @var bool
     */
    private $current;
    
    
    /**
     * ContentNavigationItem constructor.
     *
     * @param string $name
     * @param string $url
     * @param bool   $current
     */
    private function __construct(string $name, string $url, bool $current)
    {
        $this->name    = $name;
        $this->url     = $url;
        $this->current = $current;
    }
    
    
    /**
     * Factory method for content navigation item.
     *
     * @param string $name
     * @param string $url
     * @param bool   $current
     *
     * @return static
     */
    public static function create(string $name, string $url, bool $current): self
    {
        return new static($name, $url, $current);
    }
    
    
    /**
     * Array serialization.
     *
     * @return array
     */
    public function toArray(): array
    {
        if ($this->current) {
            return [
                $this->name => ''
            ];
        }
        
        return [
            $this->name => $this->url
        ];
    }
}